(function ($) {
  "use strict";

  /*------------- preloader js --------------*/
  function loader() {
    $(window).on("load", function () {
      $("#ctn-preloader").addClass("loaded");
      $("#loading").fadeOut(500);
      // Una vez haya terminado el preloader aparezca el scroll

      if ($("#ctn-preloader").hasClass("loaded")) {
        // Es para que una vez que se haya ido el preloader se elimine toda la seccion preloader
        $("#preloader")
          .delay(900)
          .queue(function () {
            $(this).remove();
          });
      }
    });
  }
  loader();

  // menu-last class
  $(".header__menu nav > ul > li").slice(-4).addClass("menu-last");

  // sticky
  var wind = $(window);
  var sticky = $("#sticky-header");
  wind.on("scroll", function () {
    var scroll = wind.scrollTop();
    if (scroll < 100) {
      sticky.removeClass("sticky-header");
    } else {
      sticky.addClass("sticky-header");
    }
  });

  // meanmenu
  $("#mobile-menu-active").metisMenu();

  $("#mobile-menu-active .has-children > a").on("click", function (e) {
    e.preventDefault();
  });

  $(".open-mobile-menu > a").on("click", function (e) {
    e.preventDefault();
    $(".slide-bar").toggleClass("show");
    $("body").addClass("on-side");
    $(".body-overlay").addClass("active");
    $(this).addClass("active");
  });

  $(".close-mobile-menu > a").on("click", function (e) {
    e.preventDefault();
    $(".slide-bar").removeClass("show");
    $("body").removeClass("on-side");
    $(".body-overlay").removeClass("active");
    $(".open-mobile-menu > a").removeClass("active");
  });

  $(".body-overlay").on("click", function () {
    $(this).removeClass("active");
    $(".slide-bar").removeClass("show");
    $("body").removeClass("on-side");
    $(".open-mobile-menu > a").removeClass("active");
  });

  // menu-last class
  $(".main-menu nav > ul > li").slice(-4).addClass("menu-last");

  $(".info-bar").on("click", function () {
    $(".extra-info").addClass("info-open");
  });

  $(".close-icon").on("click", function () {
    $(".extra-info").removeClass("info-open");
  });

  $(window).on("scroll", function () {
    var scroll = $(window).scrollTop();
    if (scroll < 245) {
      $(".header-sticky").removeClass("sticky");
    } else {
      $(".header-sticky").addClass("sticky");
    }
  });

  // data - background
  $("[data-background]").each(function () {
    $(this).css("background-image", "url(" + $(this).attr("data-background") + ")");
  });

  $("[data-bg-color]").each(function () {
    $(this).css("background", $(this).attr("data-bg-color"));
  });

  /* Search
	-------------------------------------------------------*/
  var $searchWrap = $(".search-wrap");
  var $navSearch = $(".nav-search");
  var $searchClose = $("#search-close");

  $(".search-trigger").on("click", function (e) {
    e.preventDefault();
    $searchWrap.animate({ opacity: "toggle" }, 500);
    $navSearch.add($searchClose).addClass("open");
  });

  $(".search-close").on("click", function (e) {
    e.preventDefault();
    $searchWrap.animate({ opacity: "toggle" }, 500);
    $navSearch.add($searchClose).removeClass("open");
  });

  function closeSearch() {
    $searchWrap.fadeOut(200);
    $navSearch.add($searchClose).removeClass("open");
  }

  $(document.body).on("click", function (e) {
    closeSearch();
  });

  $(".search-trigger, .main-search-input").on("click", function (e) {
    e.stopPropagation();
  });

  // Activate rtl slider
  let rtl_setting = $("body").hasClass("rtl") ? true : false;

  // mainSlider
  function mainSlider() {
    var CarouselWidgetHandler = function () {
      $("[data-background]").each(function () {
        $(this).css("background-image", "url(" + $(this).attr("data-background") + ")");
      });

      var BasicSlider = $(".slider-active");
      BasicSlider.on("init", function (e, slick) {
        var $firstAnimatingElements = $(".single-slider:first-child").find("[data-animation]");
        doAnimations($firstAnimatingElements);
      });
      BasicSlider.on("beforeChange", function (e, slick, currentSlide, nextSlide) {
        var $animatingElements = $('.single-slider[data-slick-index="' + nextSlide + '"]').find("[data-animation]");
        doAnimations($animatingElements);
      });
      BasicSlider.slick({
        autoplay: false,
        autoplaySpeed: 10000,
        dots: false,
        fade: true,
        rtl: rtl_setting,
        arrows: true,
        prevArrow: '<button type="button" class="slick-prev"><i class="fas fa-arrow-left"></i></button>',
        nextArrow: '<button type="button" class="slick-next"><i class="fas fa-arrow-right"></i></button>',
        responsive: [
          {
            breakpoint: 1024,
            settings: {
              slidesToShow: 1,
              slidesToScroll: 1,
              infinite: true,
            },
          },
          {
            breakpoint: 991,
            settings: {
              slidesToShow: 1,
              slidesToScroll: 1,
              arrows: false,
            },
          },
          {
            breakpoint: 767,
            settings: {
              slidesToShow: 1,
              slidesToScroll: 1,
              arrows: false,
            },
          },
        ],
      });
    };

    //# Make sure you run this code under Elementor..
    $(window).on("elementor/frontend/init", function () {
      elementorFrontend.hooks.addAction("frontend/element_ready/slider.default", CarouselWidgetHandler);
    });

    function doAnimations(elements) {
      var animationEndEvents = "webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend";
      elements.each(function () {
        var $this = $(this);
        var $animationDelay = $this.data("delay");
        var $animationType = "animated " + $this.data("animation");
        $this.css({
          "animation-delay": $animationDelay,
          "-webkit-animation-delay": $animationDelay,
        });
        $this.addClass($animationType).one(animationEndEvents, function () {
          $this.removeClass($animationType);
        });
      });
    }
  }
  mainSlider();

  // owlCarousel
  $(".brand-active").owlCarousel({
    loop: true,
    margin: 30,
    items: 1,
    navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
    nav: false,
    rtl: rtl_setting,
    dots: false,
    responsive: {
      0: {
        items: 2,
      },
      767: {
        items: 4,
      },
      992: {
        items: 5,
      },
      1200: {
        items: 5,
      },
    },
  });

  // blog - active
  $(".postbox__gallery").slick({
    dots: false,
    arrows: true,
    infinite: true,
    speed: 300,
    prevArrow: '<button type="button" class="slick-prev"><i class="fas fa-arrow-left"></i></button>',
    nextArrow: '<button type="button" class="slick-next"><i class="fas fa-arrow-right"></i></button>',
    slidesToShow: 1,
    rtl: rtl_setting,
    slidesToScroll: 1,
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1,
          infinite: true,
        },
      },
      {
        breakpoint: 991,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1,
        },
      },
      {
        breakpoint: 480,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1,
        },
      },
    ],
  });

  // team - active
  $(".team-active").slick({
    dots: false,
    arrows: false,
    infinite: true,
    speed: 300,
    prevArrow: '<button type="button" class="slick-prev"><i class="fas fa-arrow-left"></i></button>',
    nextArrow: '<button type="button" class="slick-next"><i class="fas fa-arrow-right"></i></button>',
    slidesToShow: 3,
    rtl: rtl_setting,
    slidesToScroll: 1,
    responsive: [
      {
        breakpoint: 1200,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 1,
          infinite: true,
        },
      },
      {
        breakpoint: 991,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 1,
        },
      },
      {
        breakpoint: 767,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 1,
        },
      },
      {
        breakpoint: 550,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1,
        },
      },
    ],
  });

  // blog - active
  $(".service-active").slick({
    dots: false,
    arrows: false,
    infinite: true,
    speed: 300,
    prevArrow: '<button type="button" class="slick-prev"><i class="fal fa-angle-left"></i></button>',
    nextArrow: '<button type="button" class="slick-next"><i class="fal fa-angle-right"></i></button>',
    slidesToShow: 3,
    rtl: rtl_setting,
    slidesToScroll: 1,
    responsive: [
      {
        breakpoint: 1199,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 1,
          infinite: true,
          arrows: false,
        },
      },
      {
        breakpoint: 991,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 1,
        },
      },
      {
        breakpoint: 767,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1,
          arrows: false,
        },
      },
    ],
  });
  // blog - active
  $(".h4gallery-active").slick({
    dots: true,
    arrows: true,
    infinite: true,
    speed: 300,
    prevArrow: '<button type="button" class="slick-prev"><i class="fal fa-angle-left"></i></button>',
    nextArrow: '<button type="button" class="slick-next"><i class="fal fa-angle-right"></i></button>',
    slidesToShow: 2,
    rtl: rtl_setting,
    slidesToScroll: 1,
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 1,
          infinite: true,
        },
      },
      {
        breakpoint: 991,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1,
        },
      },
      {
        breakpoint: 480,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1,
          arrows: false,
        },
      },
    ],
  });

  /* magnificPopup img view */
  $(".popup-image,.footer-widget .gallery-icon a").magnificPopup({
    type: "image",
    gallery: {
      enabled: true,
    },
  });

  /* magnificPopup video view */
  $(".popup-video").magnificPopup({
    type: "iframe",
  });

  // isotop
  $(".blog-masonry").imagesLoaded(function () {
    // init Isotope
    var $grid = $(".blog-masonry").isotope({
      itemSelector: ".grid-item",
      percentPosition: true,
      masonry: {
        // use outer width of grid-sizer for columnWidth
        columnWidth: ".grid-item",
      },
    });
  });

  // isotop
  $(".row-portfolio").imagesLoaded(function () {
    // init Isotope
    var $grid = $(".row-portfolio").isotope({
      itemSelector: ".grid-item",
      percentPosition: true,
      masonry: {
        // use outer width of grid-sizer for columnWidth
        columnWidth: ".grid-sizer",
      },
    });

    // filter items on button click
    $(".portfolio-filter").on("click", "button", function () {
      var filterValue = $(this).attr("data-filter");
      $grid.isotope({ filter: filterValue });
    });
  });
  //for menu active class
  $(".portfolio-filter button").on("click", function (event) {
    $(this).siblings(".active").removeClass("active");
    $(this).addClass("active");
    event.preventDefault();
  });

  // isotop
  $(".gallery-portfolio").imagesLoaded(function () {
    // init Isotope
    var $grid = $(".gallery-portfolio").isotope({
      itemSelector: ".grid-gallery",
      percentPosition: true,
    });
    // filter items on button click
    $(".gallery-filter").on("click", "button", function () {
      var filterValue = $(this).attr("data-filter");
      $grid.isotope({ filter: filterValue });
    });
    //for menu active class
    $(".gallery-filter button").on("click", function (event) {
      $(this).siblings(".active").removeClass("active");
      $(this).addClass("active");
      event.preventDefault();
    });
  });

  // counterUP
  $(".counter").counterUp({
    delay: 10,
    time: 1000,
  });

  // testimonials-active
  var TestWidgetHandler = function () {
    $(".testimonials-activation").slick({
      dots: true,
      arrows: false,
      infinite: true,
      rtl: rtl_setting,
      autoplay: true,
      autoplaySpeed: 2000,
      speed: 900,
      slidesToShow: 2,
      slidesToScroll: 1,
      responsive: [
        {
          breakpoint: 1024,
          settings: {
            slidesToShow: 1,
            slidesToScroll: 1,
            infinite: true,
            dots: false,
          },
        },
        {
          breakpoint: 600,
          settings: {
            slidesToShow: 1,
            slidesToScroll: 2,
          },
        },
        {
          breakpoint: 480,
          settings: {
            slidesToShow: 1,
            slidesToScroll: 1,
          },
        },
        // You can unslick at a given breakpoint now by adding:
        // settings: "unslick"
        // instead of a settings object
      ],
    });

    // owlCarousel
    $(".test-active").owlCarousel({
      loop: true,
      margin: 30,
      items: 1,
      rtl: rtl_setting,
      navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
      nav: false,
      dots: false,
      responsive: {
        0: {
          items: 1,
          margin: 0,
        },
        767: {
          items: 2,
        },
        992: {
          items: 2,
        },
        1200: {
          items: 3,
        },
      },
    });
  };
  //# Make sure you run this code under Elementor..
  $(window).on("elementor/frontend/init", function () {
    elementorFrontend.hooks.addAction("frontend/element_ready/testimonial_slider.default", TestWidgetHandler);
  });

  // team-active
  $(".team-activation").slick({
    dots: true,
    infinite: false,
    speed: 300,
    arrows: false,
    slidesToShow: 6,
    rtl: rtl_setting,
    slidesToScroll: 1,
    responsive: [
      {
        breakpoint: 1200,
        settings: {
          slidesToShow: 4,
          slidesToScroll: 1,
          infinite: true,
          dots: true,
        },
      },
      {
        breakpoint: 600,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 2,
        },
      },
      {
        breakpoint: 480,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 1,
        },
      },
      // You can unslick at a given breakpoint now by adding:
      // settings: "unslick"
      // instead of a settings object
    ],
  });

  // scrollToTop
  $.scrollUp({
    scrollName: "scrollUp", // Element ID
    topDistance: "300", // Distance from top before showing element (px)
    topSpeed: 300, // Speed back to top (ms)
    animation: "fade", // Fade, slide, none
    animationInSpeed: 200, // Animation in speed (ms)
    animationOutSpeed: 200, // Animation out speed (ms)
    scrollText: '<i class="fas fa-chevron-up"></i>', // Text for element
    activeOverlay: false, // Set CSS color to display scrollUp active point, e.g '#00FFFF'
  });

  // nice-slector
  $(".appoinment-form-box select,.calculate-content select,.contact-input select").niceSelect();

  // WOW active
  new WOW().init();

  /*-------------------------
		showlogin toggle function
	--------------------------*/
  $("#showlogin").on("click", function () {
    $("#checkout-login").slideToggle(900);
  });

  /*-------------------------
		showcoupon toggle function
	--------------------------*/
  $("#showcoupon").on("click", function () {
    $("#checkout_coupon").slideToggle(900);
  });

  /*-------------------------
		Create an account toggle function
	--------------------------*/
  $("#cbox").on("click", function () {
    $("#cbox_info").slideToggle(900);
  });

  /*-------------------------
		Create an account toggle function
	--------------------------*/
  $("#ship-box").on("click", function () {
    $("#ship-box-info").slideToggle(1000);
  });

  // map
  function basicmap() {
    // Basic options for a simple Google Map
    // For more options see: https://developers.google.com/maps/documentation/javascript/reference#MapOptions
    var mapOptions = {
      // How zoomed in you want the map to start at (always required)
      zoom: 11,
      scrollwheel: false,
      // The latitude and longitude to center the map (always required)
      center: new google.maps.LatLng(40.67, -73.94), // New York
      // This is where you would paste any style found on Snazzy Maps.
      styles: [
        { stylers: [{ hue: "#dd0d0d" }] },
        { featureType: "road", elementType: "labels", stylers: [{ visibility: "off" }] },
        { featureType: "road", elementType: "geometry", stylers: [{ lightness: 100 }, { visibility: "simplified" }] },
      ],
    };
    // Get the HTML DOM element that will contain your map
    // We are using a div with id="map" seen below in the <body>
    var mapElement = document.getElementById("contact-map");

    // Create the Google Map using our element and options defined above
    var map = new google.maps.Map(mapElement, mapOptions);

    // Let's also add a marker while we're at it
    var marker = new google.maps.Marker({
      position: new google.maps.LatLng(40.67, -73.94),
      map: map,
      title: "Cryptox",
    });
  }
  if ($("#contact-map").length != 0) {
    google.maps.event.addDomListener(window, "load", basicmap);
  }
})(jQuery);
